import nltk
from nltk.probability import FreqDist
from nucular import Nucular

SIMPLE_ARCHIVE = 'c:/users/vaidhy/Development/scipy/archive/simple'

def getResults(w):
    archive = Nucular.Nucular(SIMPLE_ARCHIVE)
    q = archive.Query()
    q.anyWord(w)
    results = q.resultDictionaries()[0]
    return results

def extractEntityNames(t):
    entity_names = set()
    print t
    if hasattr(t, 'node') and t.node:
        if t.node == 'NE':
            entity_names.add(' '.join([child[0] for child in t]))
        else:
            for child in t:
                entity_names.update(extractEntityNames(child))
                
    return entity_names
    
def findNE(w):
    results = getResults(w)
    sentences = nltk.sent_tokenize(results['content'])
    tokenized_sentences = [nltk.word_tokenize(sentence) for sentence in sentences[:3]]
    tagged_sentences = [nltk.pos_tag(sentence) for sentence in tokenized_sentences]
    chunked_sentences = nltk.batch_ne_chunk(tagged_sentences, binary=True)
    
    entity_names = set()
    for tree in chunked_sentences:
        entity_names.update(extractEntityNames(tree))
            
    print entity_names
        
        
if __name__ == "__main__":   
    findNE('parseltongue')
